/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.assembler;

import emulator.assembler.SymbolTable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SymbolTableTest {
    private SymbolTable table;

    @Before
    public void setUp() throws Exception {
        this.table = new SymbolTable();
        this.table.addSymbol(115, "CHRGET", "Read next input char", 1);
        this.table.addSymbol(49152, null, "Basic start", 3);
        this.table.addSymbol(64802, "RESET", null, 1);
        this.table.addSymbol(64831, null, "Check For A-ROM", 1);
    }

    @Test
    public void testGetLabel() {
        Assert.assertNull((Object)this.table.getJumpLabel(4660));
        Assert.assertEquals((Object)"CHRGET", (Object)this.table.getJumpLabel(115));
        Assert.assertNull((Object)this.table.getJumpLabel(49152));
        Assert.assertEquals((Object)"RESET", (Object)this.table.getJumpLabel(64802));
        Assert.assertNull((Object)this.table.getJumpLabel(64831));
    }

    @Test
    public void testLabelOrAddress() {
        Assert.assertEquals((Object)"$1234", (Object)this.table.getLabelOrAddress(4660));
        Assert.assertEquals((Object)"CHRGET", (Object)this.table.getLabelOrAddress(115));
        Assert.assertEquals((Object)"$C000", (Object)this.table.getLabelOrAddress(49152));
        Assert.assertEquals((Object)"RESET", (Object)this.table.getLabelOrAddress(64802));
    }

    @Test
    public void testLabelFromAddress() {
        Assert.assertEquals((Object)"L_1234", (Object)this.table.createJumpLabel(4660));
        Assert.assertEquals((Object)"CHRGET", (Object)this.table.createJumpLabel(115));
        Assert.assertEquals((Object)"L_C000", (Object)this.table.createJumpLabel(49152));
        Assert.assertEquals((Object)"RESET", (Object)this.table.createJumpLabel(64802));
        Assert.assertEquals((Object)"L_FD3F", (Object)this.table.createJumpLabel(64831));
        Assert.assertNull((Object)this.table.getJumpLabel(40960));
        Assert.assertEquals((Object)"L_1234", (Object)this.table.getJumpLabel(4660));
        Assert.assertEquals((Object)"CHRGET", (Object)this.table.getJumpLabel(115));
        Assert.assertEquals((Object)"L_C000", (Object)this.table.getJumpLabel(49152));
        Assert.assertEquals((Object)"RESET", (Object)this.table.getJumpLabel(64802));
        Assert.assertEquals((Object)"L_FD3F", (Object)this.table.getJumpLabel(64831));
    }

    @Test
    public void testGetRemark() {
        Assert.assertNull(null, (Object)this.table.getRemark(4660));
        Assert.assertEquals((Object)"Read next input char", (Object)this.table.getRemark(115));
        Assert.assertEquals((Object)"Basic start", (Object)this.table.getRemark(49152));
        Assert.assertNull(null, (Object)this.table.getRemark(64802));
    }
}

